function [CM,AUC,ROCX,ROCY,AUPR,PRX,PRY]=MIDATEST(beta,test,testInstanceIndex,testLabel)
%   Test the performance of the MIDA model.
%
%[CM,AUC,ROCX,ROCY,AUPR,PRX,PRY]=MIDATEST(beta,test,testInstanceIndex,testLabel)
% input:
% beta: (k+1)*1 vector, the beta cofficient vector.
% test: n*k matrix, the tested Twitter data.
% testInstanceIndex: n*1 vector, the mapping from tested tweets to tested users.
% testLabel: n*1 vector,the label of tested users.
% where:
% n=number of tweets.
% k=number of keywords.
% output:
% CM: confusion matrix.
% AUC: the area under the ROC curve.
% ROCX: the X axis of the ROC curve.
% ROCY: the Y axis of the ROC curve.
% AUPR: the area under the PR curve.
% PRX: the X axis of the PR curve.
% PRY: the Y axis of the PR curve.
l = length(testLabel);
k = size(test,2);
test =[ones(size(test,1),1),test];
S=test*beta;
maxS=zeros(l,1);
maxInstance=zeros(l,k+1);
for i=1:l
    index = find(testInstanceIndex==i);
    if ~isempty(index)
        [maxS(i),pos]=max(S(index));
        maxInstance(i,:) =test(index(pos),:);
    else
        maxS(i)=beta(1);
        maxInstance(i,:) =[1,zeros(1,k)];
    end
end
CM=confusionmat(testLabel,(maxS>=0)*1);
[ROCX,ROCY,~,AUC]=perfcurve(testLabel,1./(1+exp(-maxS)),1);
[PRX,PRY,~,AUPR]= perfcurve(testLabel, 1./(1+exp(-maxS)), 1, 'xCrit', 'reca', 'yCrit', 'prec');
end